package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.characteristics.Characteristic;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CharacteristicDialog extends GenericDialog {
	private static final long serialVersionUID = -4934138382056573402L;

	protected Characteristic characteristic;

	protected JComboBox affectsCombo;

	protected JLabel affectsLbl;

	protected JCheckBox addModifiersToBaseCB;

	public CharacteristicDialog(Characteristic pow, boolean isNew,
			boolean isPower) {
		super(pow, isNew, isPower);
		characteristic = pow;
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 75;
		gbc.weightx = 0;
		gbc.weighty = 0;
		panel.add(affectsLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(affectsCombo, gbc);
		gbc.gridy = 76;
		gbc.gridx = 0;
		gbc.gridwidth = 3;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.insets = new Insets(10, 2, 2, 5);
		panel.add(addModifiersToBaseCB, gbc);
		gbc.gridy = 91;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridx = 2;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridy = 70;
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		affectsCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (affectsCombo.getSelectedIndex() == 0) {
					characteristic.setAffectPrimary(true);
					characteristic.setAffectTotal(true);
				} else if (affectsCombo.getSelectedIndex() == 1) {
					characteristic.setAffectPrimary(false);
					characteristic.setAffectTotal(true);
				} else {
					characteristic.setAffectPrimary(false);
					characteristic.setAffectTotal(false);
				}
			}
		});
		addModifiersToBaseCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				characteristic.setAddModifiersToBase(addModifiersToBaseCB
						.isSelected());
				updateValues();
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		affectsLbl = new JLabel("Totaling Options:");
		ArrayList<String> vec = new ArrayList<String>();
		vec.add("Add to Primary Value");
		vec.add("Add to Secondary Value");
		vec.add("Do not add to Totals");
		affectsCombo = new JComboBox(vec.toArray());
		if (characteristic.getAffectPrimary()) {
			affectsCombo.setSelectedIndex(0);
		} else if (characteristic.getAffectTotal()) {
			affectsCombo.setSelectedIndex(1);
		} else {
			affectsCombo.setSelectedIndex(2);
		}
		addModifiersToBaseCB = new JCheckBox(
				"Add Modifiers to Base Characteristic");
		if (characteristic.addModifiersToBase()) {
			addModifiersToBaseCB.setSelected(true);
		}
	}

	@Override
	public void updateValues() {
		super.updateValues();
	}
}